LoadScript("gallery.lua")

gGallery = LoadTable("gallery.bin")
gPlayers = {}

-- player init / cleanup
RegisterNetworkEventHandler("admin_gallery:Init",function(player)
	for role in AllConfigStrings(GetScriptConfig(),"allow_role") do
		if DoesPlayerHaveRole(player,role) then
			local first = gGallery[1]
			if first then
				SendNetworkEvent(player,"admin_gallery:Download",first)
				gPlayers[player] = {ready = false,[first] = true}
			else
				gPlayers[player] = {ready = true} -- ready to download
			end
			SendNetworkEvent(player,"admin_gallery:Allow")
			return
		end
	end
end)
RegisterLocalEventHandler("PlayerDropped",function(player)
	gPlayers[player] = nil
end)

-- network messages
RegisterNetworkEventHandler("admin_gallery:Next",function(player)
	local sent = gPlayers[player]
	if sent then
		local image = F_GetNextUnsent(sent)
		if sent.ready then
			PrintWarning("unexpected admin_gallery:Next from "..GetPlayerName(player))
		elseif image then
			SendNetworkEvent(player,"admin_gallery:Download",image)
			sent[image] = true
		else
			sent.ready = true -- ready to download
		end
	end
end)
RegisterNetworkEventHandler("admin_gallery:Upload",function(player,name,data)
	if gPlayers[player] and type(name) == "string" and type(data) == "string" and string.len(data) <= gMaxSize then
		if table.getn(gGallery) >= gMaxCount then
			SendNetworkEvent(player,"admin_gallery:Failure","no more space")
		elseif F_GetByName(name) then
			SendNetworkEvent(player,"admin_gallery:Failure","name already taken")
		else
			F_AddNewImage(name,data,player)
			SendNetworkEvent(player,"admin_gallery:Success",name)
		end
		SendNetworkEvent(player,"admin_gallery:Ready")
	end
end)
RegisterNetworkEventHandler("admin_gallery:Delete",function(player,name)
	if gPlayers[player] and type(name) == "string" then
		local index = 1
		name = string.lower(name)
		while gGallery[index] do
			local image = gGallery[index]
			if string.lower(image.name) == name then
				for _,sent in pairs(gPlayers) do
					sent[image] = nil
				end
				table.remove(gGallery,index)
			else
				index = index + 1
			end
			image = gGallery[index]
		end
		collectgarbage()
		for peer in pairs(gPlayers) do
			SendNetworkEvent(peer,"admin_gallery:Remove",name)
		end
		SaveTable("gallery.bin",gGallery)
	end
end)

-- gallery utility
function F_AddNewImage(name,data,player)
	local image = {name = name,png = data}
	if player then
		image.who = GetPlayerName(player)
	end
	table.insert(gGallery,image)
	for peer,sent in pairs(gPlayers) do
		if sent.ready then
			SendNetworkEvent(peer,"admin_gallery:Download",image)
			sent[image] = true
			sent.ready = false
		end
	end
	SaveTable("gallery.bin",gGallery)
end
function F_GetNextUnsent(sent)
	for _,image in ipairs(gGallery) do
		if not sent[image] then
			return image
		end
	end
end
function F_GetByName(name)
	name = string.lower(name)
	for _,image in ipairs(gGallery) do
		if string.lower(image.name) == name then
			return image
		end
	end
end
